/**
 * \file: aauto_macros.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Aauto macro utils
 *
 * \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2013-2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTO_MACROS_H
#define AAUTO_MACROS_H

#ifndef nullptr
#define nullptr 0
#define _aauto_nullptr
#endif

/* coding rule exception: exit() is used to quit after FATAL errors */
#define aauto_exit_on_null(ptr) do { if (ptr == nullptr) \
    { fprintf(stderr, "null ptr @ %s: " #ptr "\n", __FUNCTION__); exit(1); } } while (0)
#define aauto_exit_on_invalid_argument(cond) do { if (cond) \
    { fprintf(stderr, "invalid argument @ %s: " #cond "\n", __FUNCTION__); exit(1); } } while (0)
#define aauto_return_on_invalid_argument(context, cond) do { if (cond) \
    { fprintf(stderr, "invalid argument @ %s: " #cond "\n", __FUNCTION__); return; } } while (0)
#define aauto_return_value_on_null(context, ptr, val) do { if (ptr == nullptr ) \
    { fprintf(stderr, "null ptr @ %s: " #ptr "\n", __FUNCTION__); return val; } } while (0)
#define aauto_return_value_on_invalid_argument(context, cond, val) do { if (cond) \
    { fprintf(stderr, "invalid argument @ %s: " #cond "\n", __FUNCTION__); return val; } } while (0)

#define aauto_safe_delete(ptr) do { if (ptr != nullptr) \
    { delete ptr; ptr = nullptr; } } while (0)
#define aauto_safe_delete_array(ptr) do { if (ptr != nullptr) \
    { delete[] ptr; ptr = nullptr; } } while (0)
#define aauto_safe_call(call, ptr) do { if (ptr != nullptr) \
    { call(ptr); ptr = nullptr; } } while (0)

#ifdef _aauto_nullptr
#undef nullptr
#endif

#endif /* AAUTO_MACROS_H */
